/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Sputtering Firework by eiffie (simple particle gen)
// I'm sure this has been done before and probably better but I had to try too.

vec3 Segment(vec3 ro, vec3 rd, vec3 p1, vec3 p2, out float a){//probably came from iq originally
	vec3 pS=p1-ro,pD=p2-ro-pS;
	float d=dot(rd,pD),t=clamp((dot(rd,pS)*d-dot(pS,pD))/(dot(pD,pD)-d*d),0.0,1.0);
	pS+=pD*t;
	pS=dot(pS,rd)*rd-pS;
	a=t*(1.0-d*d/dot(pD,pD));//abs(dot(rd,normalize(pD))));
	return pS;
}
mat3 lookat(vec3 fw,vec3 up){
	fw=normalize(fw);vec3 rt=normalize(cross(fw,up));return mat3(rt,cross(rt,fw),fw);
}
void main( void )
{
	float time=iGlobalTime*0.25;
	vec2 uv = 2.0*(gl_FragCoord.xy-0.5*iResolution.xy)/iResolution.y;
	vec3 ro=vec3(2.0*sin(time*0.5),1.0,2.0*cos(time*0.5));
	mat3 rotCam=lookat(vec3(0.0,0.25,0.0)-ro,vec3(0.0,1.0,0.0));
	vec3 rd=rotCam*normalize(vec3(uv,1.5));
	float t=-ro.y/rd.y,a,W;
	vec3 roR=ro+rd*t;
	vec3 rdR=rd;rdR.y*=-1.0;
	t=length(roR)-0.15;
	bool bR=(t>0.0);
	vec3 col = (!bR?vec3(0.5,0.3,0.1)*-t*10.0:vec3(0.125+rd.y*0.25));
   vec3 rnd=texture2D(iChannel0,uv*0.75).rgb*0.025;
	vec3 F1,F2;
	for(float i=0.0;i<100.0;i+=1.0){
		float a1=mod(time+i*0.01,1.75),h1=(1.0+sin(i*27.39)*0.25);
		float a2=mod(time+0.075+i*0.01,1.75),h2=h1;
		vec2 dr=vec2(sin(i),cos(i));
		F1.xz=dr*a1*h1;W=a1;
		F2.xz=dr*a2*h2;
		for(int j=0;j<3;j++){
			if(a1>1.0){a1=(a1-1.0)*2.0;h1*=0.5;}
			if(a2>1.0){a2=(a2-1.0)*2.0;h2*=0.5;}
		}
		h1*=abs(sin(a1*3.1416));
		h2*=abs(sin(a2*3.1416));
		F1.y=h1;F2.y=h2;
		vec3 tp=Segment(ro,rd,F2,F1,a)-rnd;
		t=dot(tp.xyz,tp.xyz);
		col+=mix(vec3(1.0,0.7+0.3-t*200.0-a,0.4),vec3(0.5,0.0,0.0),W*0.57)*clamp(smoothstep(-0.005,0.0,-t-W*0.001)-W*0.4-a,0.0,1.0);
		if(bR){
			tp=F2-(roR+rdR*length(roR-F2)-rnd);
			col+=clamp(smoothstep(-0.01,0.0,-dot(tp,tp))-W*0.57,0.0,1.0)*vec3(0.15);
		}
	}

	gl_FragColor = vec4( col, 1.0 );
}